<?php
session_start(); // Inicia a sessão



// Caminho para o arquivo JSON e diretório de upload
$jsonFile = './img/api.json'; // Caminho do arquivo JSON
$uploadDir = './img/'; // Diretório de uploads

// Função para carregar os dados do JSON
function carregarDadosJson() {
    global $jsonFile;
    $jsonData = file_get_contents($jsonFile);
    return json_decode($jsonData, true);
}

// Função para atualizar o arquivo JSON
function atualizarJson($novoNomeLogo) {
    global $jsonFile;
    $jsonData = file_get_contents($jsonFile);
    $data = json_decode($jsonData, true);

    // Atualizando o nome da logo no JSON
    $data['data'][0]['logo'] = $novoNomeLogo;

    // Salvando as alterações no arquivo JSON
    file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
}

// Carregar os dados do JSON
$dados = carregarDadosJson();

// Verifica se o formulário de upload foi enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {

    // Nome do arquivo a ser renomeado para logo.png
    $novoNomeLogo = "logo.png";

    // Verifica se o arquivo é uma imagem válida (opcional)
    $fileTmpPath = $_FILES['logo']['tmp_name'];
    $fileName = $_FILES['logo']['name'];
    $fileSize = $_FILES['logo']['size'];
    $fileType = $_FILES['logo']['type'];

    // Verifica se o arquivo enviado é uma imagem
    $imageInfo = getimagesize($fileTmpPath);
    if ($imageInfo === false) {
        echo "<div class='container logo-msg error'>O arquivo enviado não é uma imagem válida.</div>";
        exit;
    }

    // Se for PNG ou JPEG, podemos usar o arquivo diretamente, caso contrário, converte para PNG
    $image = null;
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($ext == 'png') {
        $image = imagecreatefrompng($fileTmpPath); // Cria imagem de um arquivo PNG
    } elseif ($ext == 'jpg' || $ext == 'jpeg') {
        $image = imagecreatefromjpeg($fileTmpPath); // Cria imagem de um arquivo JPEG
    } elseif ($ext == 'gif') {
        $image = imagecreatefromgif($fileTmpPath); // Cria imagem de um arquivo GIF
    } else {
        echo "<div class='container logo-msg error'>Formato de imagem não suportado. Envie PNG, JPG ou GIF.</div>";
        exit;
    }

    // Criação da imagem PNG com fundo transparente
    imagealphablending($image, false); // Desativa a mesclagem de pixels
    imagesavealpha($image, true); // Preserva a transparência

    // Salva a imagem como PNG no diretório de uploads
    if (imagepng($image, $uploadDir . $novoNomeLogo)) {
        // Atualiza o JSON (caso necessário)
        atualizarJson($novoNomeLogo);

        // Limpar o cache (adicionando o timestamp para garantir que o navegador recarregue a imagem)
        $logoMensagem = "Logo enviada e salva como: " . $novoNomeLogo;
        imagedestroy($image); // Libera a memória
    } else {
        echo "<div class='container logo-msg error'>Erro ao mover o arquivo para o diretório.</div>";
    }
}

// Função para redimensionar a imagem
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['redimensionar'])) {
    $largura = filter_input(INPUT_POST, 'largura', FILTER_VALIDATE_INT);
    $altura = filter_input(INPUT_POST, 'altura', FILTER_VALIDATE_INT);

    if ($largura && $altura && $largura > 0 && $altura > 0) {
        $imagePath = $uploadDir . 'logo.png';
        if (file_exists($imagePath)) {
            $image = imagecreatefrompng($imagePath);
            if (!$image) {
                $image = imagecreatefromjpeg($imagePath);
            }
            if (!$image) {
                $image = imagecreatefromgif($imagePath);
            }

            if ($image) {
                $novaImagem = imagescale($image, $largura, $altura);

                // Preservando a transparência (apenas para PNG e GIF)
                if (exif_imagetype($imagePath) == IMAGETYPE_PNG || exif_imagetype($imagePath) == IMAGETYPE_GIF) {
                    imagealphablending($novaImagem, false);
                    imagesavealpha($novaImagem, true);
                }

                // Salvar a imagem redimensionada como PNG (mantendo a consistência do nome)
                imagepng($novaImagem, $imagePath);

                // Atualiza o JSON com a nova imagem
                atualizarJson('logo.png');
                imagedestroy($image);
                imagedestroy($novaImagem);

                $logoMensagem = "Logo redimensionada para: $largura x $altura";
            } else {
                echo "<div class='container logo-msg error'>Erro ao carregar a imagem para redimensionamento.</div>";
            }
        } else {
            echo "<div class='container logo-msg error'>Imagem da logo não encontrada para redimensionamento.</div>";
        }
    } else {
        echo "<div class='container logo-msg error'>Por favor, insira dimensões válidas para redimensionamento.</div>";
    }
}

// Obtém as dimensões da imagem atual
$imagePath = $uploadDir . 'logo.png';
$currentWidth = null;
$currentHeight = null;
if (file_exists($imagePath)) {
    $imageSize = @getimagesize($imagePath); // Use @ para evitar erros se o arquivo não for imagem
    if ($imageSize) {
        $currentWidth = $imageSize[0]; // Largura
        $currentHeight = $imageSize[1]; // Altura
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload e Redimensionamento de Logo</title>

    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>

    <style>
        /* Estilizando a página */
        body, html {
            height: 100%;
            margin: 0;
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column; /* Flexbox para o layout */
            justify-content: flex-start;
            position: relative;
        }

        /* Particles background */
        #particles-js {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0; /* Partículas ficam abaixo do conteúdo */
        }

        /* Container principal que segura os formulários e conteúdo */
        .container {
            position: relative;
            z-index: 2; /* Garantir que o conteúdo do formulário fique acima do fundo */
            text-align: center;
            padding: 20px;
            background: rgba(50, 50, 50, 0.7); /* Cinza escuro translúcido */
            color: white; /* Texto branco */
            border-radius: 8px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
            max-width: 600px;
            width: 100%;
            margin: 0 auto; /* Centraliza o conteúdo */
            margin-top: 20px; /* Espaçamento superior */
        }

        .container h2 {
            margin-bottom: 20px;
        }

        .container input[type="file"],
        .container input[type="text"],
        .container input[type="submit"] {
            padding: 10px;
            margin-bottom: 20px;
            background-color: #444; /* Cor de fundo do input */
            border: none;
            border-radius: 5px;
            color: white;
            box-sizing: border-box; /* Para que padding não aumente o tamanho */
            width: 100%; /* Inputs ocupam a largura total do container */
        }

        .container input[type="submit"]:hover {
            background-color: #17A673;
            cursor: pointer;
        }

        .container img {
            margin-top: 20px;
            width: 150px;
            height: auto;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        /* Rodapé */
        footer {
            width: 100%;
            padding: 10px;
            background-color: #000;
            color: white;
            text-align: center;
            margin-top: auto; /* Garantir que o rodapé fique ao final */
            position: relative;
            z-index: 2; /* Rodapé acima do fundo */
        }

        .bg-msg {
            margin-top: 20px;
            color: #1cc88a;
            font-weight: bold;
        }

        .bg-msg.error {
            color: #e74a3b;
        }

        /* Estilo para o form de redimensionamento */
        .redimensionar-form {
            margin-top: 20px;
            padding: 15px;
            border: 1px solid #555;
            border-radius: 5px;
            text-align: left;
        }

        .redimensionar-form h3 {
            margin-top: 0;
            margin-bottom: 10px;
            text-align: center;
        }

        .redimensionar-form label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        .redimensionar-form input[type="text"] {
            width: calc(100% - 22px); /* Ajuste para o padding */
            box-sizing: border-box;
        }

        .redimensionar-form input[type="submit"] {
            margin-top: 10px;
            width: 100%;
        }
    </style>
</head>
<body>

    <div id="particles-js"></div> <?php include 'includes/header.php'; ?>

    <div class="container">
        <h2>Envio de Logo</h2>
        <form action="upload_logo.php" method="POST" enctype="multipart/form-data">
            <label for="logo">Selecione a logo:</label>
            <input type="file" name="logo" id="logo" accept="image/*" required><br><br>
            <input type="submit" value="Enviar Logo">
        </form>

        <h3>Logo Atual:</h3>
        <?php
        // Exibe a logo atual com espaçamento adequado e com o cache limpo
        if (isset($dados['data'][0]['logo']) && file_exists('./img/' . $dados['data'][0]['logo'])) {
            $logoUrl = './img/' . $dados['data'][0]['logo'] . '?' . time(); // Parâmetro para evitar cache
            echo "<img src='$logoUrl' alt='Logo' style='max-width: 150px; height: auto;'><br>";
        } else {
            echo "<p>Nenhuma logo definida.</p>";
        }
        ?>

        <?php if ($currentWidth && $currentHeight): ?>
            <p><strong>Dimensões atuais da logo:</strong> <?php echo $currentWidth . 'x' . $currentHeight; ?> px</p>
        <?php else: ?>
            <p><strong>Dimensões atuais da logo:</strong> Desconhecidas</p>
        <?php endif; ?>

        <?php if (isset($logoMensagem)) { echo "<p class='logo-msg'>$logoMensagem</p>"; } ?>

        <div class="redimensionar-form">
            <h3>Redimensionar Logo:</h3>
            <form action="upload_logo.php" method="POST">
                <label for="largura">Largura:</label>
                <input type="text" name="largura" id="largura" value="<?php echo $currentWidth ?? ''; ?>" required>
                <label for="altura">Altura:</label>
                <input type="text" name="altura" id="altura" value="<?php echo $currentHeight ?? ''; ?>" required>
                <input type="submit" name="redimensionar" value="Redimensionar Logo">
            </form>
        </div>

    </div>

    <script>
        // Inicializa o efeito de partículas
        particlesJS('particles-js', {
            "particles": {
                "number": {
                    "value": 80,
                    "density": {
                        "enable": true,
                        "value_area": 800
                    }
                },
                "color": {
                    "value": "#1cc88a"
                },
                "shape": {
                    "type": "circle",
                    "stroke": {
                        "width": 0,
                        "color": "#000000"
                    }
                },
                "opacity": {
                    "value": 0.5,
                    "random": true,
                    "anim": {
                        "enable": true,
                        "speed": 1,
                        "opacity_min": 0.1
                    }
                },
                "size": {
                    "value": 3,
                    "random": true,
                    "anim": {
                        "enable": true,
                        "speed": 40,
                        "size_min": 0.1
                    }
                },
                "line_linked": {
                    "enable": true,
                    "distance": 150,
                    "color": "#1cc88a",
                    "opacity": 0.4,
                    "width": 1
                },
                "move": {
                    "enable": true,
                    "speed": 6,
                    "direction": "none",
                    "random": false,
                    "straight": false,
                    "out_mode": "out",
                    "attract": {
                        "enable": false,
                        "rotateX": 600,
                        "rotateY": 600
                    }
                }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": {
                    "onhover": {
                        "enable": true,
                        "mode": "repulse"
                    },
                    "onclick": {
                        "enable": true,
                        "mode": "push"
                    }
                }
            },
            "retina_detect": true
        });
    </script>

    <footer>
        <p>&copy; <?php echo date("Y"); ?> Meu Site - Todos os direitos reservados.</p>
    </footer>

</body>
</html>