<?php
session_start();

// Verificar se o código foi enviado e o username está na sessão
if (!isset($_SESSION['code_sent']) || $_SESSION['code_sent'] !== true || !isset($_SESSION['security_username'])) {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userCode = strtoupper(filter_input(INPUT_POST, 'security_code', FILTER_SANITIZE_STRING));

    if (isset($_SESSION['security_code']) && $userCode === $_SESSION['security_code']) {
        // Código de segurança correto, autenticar completamente
        $_SESSION['loggedin'] = true;
        $_SESSION['N'] = $_SESSION['security_username'];
        unset($_SESSION['security_code']);
        unset($_SESSION['security_username']);
        unset($_SESSION['code_sent']);

        // Redirecionar para a página principal
        header('Location: dns.php');
        exit();
    } else {
        $error = 'Código de segurança incorreto.';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Verificar Código de Segurança</title>
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link href="css/sb-admin-<?php echo $col2; ?>.css" rel="stylesheet">
    <link rel="shortcut icon" href="./img/logo.png" type="image/png">
    <link rel="icon" href="./img/logo.png" type="image/png">
    <link rel="stylesheet" type="text/css" href="./login/animate.css">
    <link rel="stylesheet" type="text/css" href="./login/hamburgers.min.css">
    <link rel="stylesheet" type="text/css" href="./login/select2.min.css">
    <link rel="stylesheet" type="text/css" href="./login/util.css">
    <link rel="stylesheet" type="text/css" href="./login/main.css">
    </head>
<body class="bg-gradient-primary">
    <div class="limiter">
        <div class="container-login100">
            <div class="wrap-login100">
                <div class="login100-pic js-tilt" data-tilt="" style="will-change: transform; transform: perspective(300px) rotateX(2deg) rotateY(-3.64deg) scale3d(1.1, 1.1, 1.1);">
                    <center><img src="<?php echo $logo_login; ?>"  width="250px" height="250px" "alt="IMG"><br></center>
                </div>
                <form class="login100-form validate-form" method="post">
                    <span class="text-center text-light"><h3 class="text-center text-light"><strong>Verificar Código</strong></h3>
                        <br> Um código de segurança foi enviado para o seu e-mail. <br>
                        Por favor, insira o código abaixo para continuar.
                        <br><br>
                    </span>

                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger" id="flash-msg"><h4><i class="icon fa fa-times"></i><?php echo $error; ?></h4></div>
                    <?php endif; ?>

                    <div class="wrap-input100 validate-input" data-validate="É necessário preencher o código de segurança!">
                        <input class="input100" type="text" name="security_code" placeholder="Código de Segurança">
                        <span class="focus-input100"></span>
                        <span class="symbol-input100">
                            <i class="fa fa-key" aria-hidden="true"></i>
                        </span>
                    </div>

                    <div class="container-login100-form-btn">
                        <button class="login100-form-btn text-center text-light" type="submit">
                            <strong>VERIFICAR CÓDIGO</strong>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="./login_files/jquery-3.2.1.min.js"></script>
    <script src="./login/popper.js"></script>
    <script src="./login/select2.min.js"></script>
    <script src="./login/tilt.jquery.min.js"></script>
    <script>
        $('.js-tilt').tilt({
            scale: 1.1
        })
    </script>
    <script src="./login/main.js"></script>
    <?php
    require 'includes/boxbr.php';
    ?>
</body>
</html>