<?php
/* Script by BoxBR Apks Rebrand Panels (c) - https://t.me/boxbrapk / http://boxbr.k6.com.br */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// Parâmetros de URL com verificação para evitar Undefined index
$username   = isset($_GET["username"]) ? $_GET["username"] : null;
$password   = isset($_GET["password"]) ? $_GET["password"] : null;
$device_id  = isset($_GET["device_id"]) ? $_GET["device_id"] : null;

$action      = isset($_GET['action']) ? $_GET['action'] : '';
$category_id = isset($_GET['category_id']) ? $_GET['category_id'] : '';
$stream_id   = isset($_GET['stream_id']) ? $_GET['stream_id'] : '';
$vod_id      = isset($_GET['vod_id']) ? $_GET['vod_id'] : '';
$series_id   = isset($_GET['series_id']) ? $_GET['series_id'] : '';

// Inicializa o banco de dados do DNS
$db = new SQLite3("./.boxbrdb.db");
$res = $db->query("SELECT * FROM dns");
$arr = [];

while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
    $arr[] = $row['url'];
}

$dns = NULL;

// Tenta autenticar com os DNSs encontrados
foreach ($arr as $dns3) {
    $api_call = call_api($dns3 . "/player_api.php?username=" . $username . "&password=" . $password);

    if ($api_call && isset($api_call->user_info) && $api_call->user_info->auth == 1 && $api_call->user_info->status == "Active") {
        $dns = $dns3;

        // Captura o device_id da resposta se não foi enviado por GET
        if (!$device_id && isset($api_call->user_info->device_id)) {
            $device_id = $api_call->user_info->device_id;
        }

        break;
    }
}

if ($dns !== NULL) {
    $user_db = new SQLite3('./boxbrdb.db');

    // Garante que a coluna device_id exista (sem criar a tabela inteira)
    $col_check = $user_db->querySingle("PRAGMA table_info(usuarios)");
    $colunas = [];
    $res = $user_db->query("PRAGMA table_info(usuarios)");
    while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
        $colunas[] = $row['name'];
    }
    if (!in_array('device_id', $colunas)) {
        $user_db->exec("ALTER TABLE usuarios ADD COLUMN device_id TEXT");
    }

    // Verifica se o usuário já está no banco de dados de usuários
    $stmt = $user_db->prepare("SELECT * FROM usuarios WHERE username = :username");
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $result = $stmt->execute();
    $user = $result->fetchArray(SQLITE3_ASSOC);

    if (!$user) {
        $stmt = $user_db->prepare("INSERT INTO usuarios (username, password, dns, validade, device_id) VALUES (:username, :password, :dns, :validade, :device_id)");
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $stmt->bindValue(':password', $password, SQLITE3_TEXT);
        $stmt->bindValue(':dns', $dns, SQLITE3_TEXT);
        $stmt->bindValue(':validade', date('Y-m-d H:i:s', strtotime('+360 days')), SQLITE3_TEXT);
        $stmt->bindValue(':device_id', $device_id ?? 'desconhecido', SQLITE3_TEXT);
        $stmt->execute();

        // Recarrega o usuário para fazer a validação de validade
        $stmt = $user_db->prepare("SELECT * FROM usuarios WHERE username = :username");
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $result = $stmt->execute();
        $user = $result->fetchArray(SQLITE3_ASSOC);
    }

    // Redireciona para a URL com os parâmetros recebidos
    $url = $dns . '/player_api.php?username=' . $username . '&password=' . $password;
    if ($action)      $url .= '&action=' . $action;
    if ($category_id) $url .= '&category_id=' . $category_id;
    if ($stream_id)   $url .= '&stream_id=' . $stream_id;
    if ($vod_id)      $url .= '&vod_id=' . $vod_id;
    if ($series_id)   $url .= '&series_id=' . $series_id;

    // Verificação de validade
    $currentDate = date('Y-m-d');
    if ($user['validade'] == '2050-01-01' || strtotime($user['validade']) >= strtotime($currentDate)) {
        header("Location: " . $url);
        exit;
    } else {
        echo "Acesso negado! Sua conta está bloqueada.";
        exit;
    }
} else {
    echo "Nenhum DNS válido encontrado.";
    exit;
}

// Função para chamar a API e obter resposta
function call_api($api_link)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_link);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    $result = curl_exec($ch);

    if ($result) {
        $decoded_result = json_decode($result);
        curl_close($ch);
        return $decoded_result;
    } else {
        curl_close($ch);
        return NULL;
    }
}
?>
